"""
######################################################################
# Script Name:  ODBC_export_example.py
# Version:      1.0.0
# Author:       Eduard Dercho
# Company:      IBR Messtechnik GmbH & Co. KG  
# Date:         2025-08-22
# Description:  This python script file is an example file on how to
#               link ComGage with the "SFct047 - Universal export 
#               module" to a python script and how to execute an own 
#               export by using the ODBC protocol. In order to make
#               this example script work, the connection parameters
#               for the ODBC interface must be set correctly.
#                 
#               The IBR_PythonWrapper.exe calls the "main" function 
#               with a bunch of data from ComGage. For a detailed 
#               explanation please have a look at the description of
#               the main function below.
#
######################################################################
"""
#
#---# Import of additional Python librarys needed for this example :
#
import time
import pyodbc
#
#---# ODBC connection parameters
#
# Method 1 : With DSN parameter string
conn = pyodbc.connect('DSN=exampleDB;UID=root;PWD=examplePw')

# Method 2 : Without DSN (direct input of drivers, in this case SQL Server)
#conn = pyodbc.connect(
#    "DRIVER={SQL Server};"
#    "SERVER=localhost;"
#    "DATABASE=odbc_example;"
#    "UID=root;"
#    "PWD=examplePw;"
#    "PORT=3306;"
#)

# !!! Select one of the upper methods and comment the not used method !!!

#
#---# Main Function :
#
def main(comgage_data):
    # Load the arguments of ComGage into separate variables
    result=comgage_data[0]                          # Result value which is set in the result register for this execution. Must be set as array with index 0 : result[0] = x
    to_name = comgage_data[1]                       # Name of the test order
    art_number = comgage_data[2]                    # Article number of the test scheme
    art_description = comgage_data[3]               # Article description of the test scheme
    characteristics_name = comgage_data[4]          # Array[128] with all characteristic names (example : characteristic_name[0] contains the name of characteristic 1)
    characteristics_unit = comgage_data[5]          # Array[128] with all characteristic units (example : characteristic_unit[1] contains the unit of characteristic 2)
    characteristics_nominal = comgage_data[6]       # Array[128] with all characteristic nominals (example : characteristics_nominal[2] contains the nominal of characteristic 3)
    characteristics_usl = comgage_data[7]           # Array[128] with all characteristic USL (example : characteristics_usl[3] contains the USL of characteristic 4)
    characteristics_ucl = comgage_data[8]           # Array[128] with all characteristic UCL (example : characteristics_ucl[4] contains the UCL of characteristic 5)
    characteristics_lcl = comgage_data[9]           # Array[128] with all characteristic LCL (example : characteristics_lcl[5] contains the LCL of characteristic 6)
    characteristics_lsl = comgage_data[10]          # Array[128] with all characteristic LSL (example : characteristics_lsl[6] contains the LSL of characteristic 7)
    characteristics_utl = comgage_data[11]          # Array[128] with all characteristic UTL (example : characteristics_utl[7] contains the UTL of characteristic 8)
    characteristics_ltl = comgage_data[12]          # Array[128] with all characteristic LTL (example : characteristics_ltl[8] contains the LTL of characteristic 9)
    characteristics_master1 = comgage_data[13]      # Array[128] with all characteristic master 1 (example : characteristics_master1[9] contains the master 1 of characteristic 10)
    characteristics_master2 = comgage_data[14]      # Array[128] with all characteristic master 2 (example : characteristics_master2[10] contains the master 2 of characteristic 11)
    characteristics_note = comgage_data[15]         # Array[128] with all characteristic notes (example : characteristics_note[11] contains the note of characteristic 12)
    characteristics_mea_val = comgage_data[16]      # Array[128] with all characteristic measuring values (example : characteristics_mea_val[12] contains the measuring values of characteristic 13)
    characteristics_tol_result = comgage_data[17]   # Array[128] with all characteristic tolerance results (example : characteristics_tol_result[13] contains the tolerance result of characteristic 14)
    reference_information = comgage_data[18]        # Array[30][128] with alle reference information that are saved for each characteristic (example: reference_information[4][14] contains the reference information 5 value of characteristic 15)  
    test_scheme_directory = comgage_data[19]            # Path of the test scheme directory from ComGage
    test_order_directory = comgage_data[20]             # Path of the test order directory from ComGage
    measuring_data_directory = comgage_data[21]         # Path of the measuring data directory from ComGage
    pictures_directory = comgage_data[22]               # Path of the pictures directory from ComGage
    reference_information_directory = comgage_data[23]  # Path of the reference information directory from ComGage
    
    try:
        # Get the cursor for the database
        cursor = conn.cursor()

        # Example : Insert the measuring value of characteristic 1 and 2 into the database table 'Measuringvalues' with the column names 'Characteristic' and 'Value'
        cursor.execute("INSERT INTO Measuringvalues (Characteristic, `Value`) VALUES (?, ?)", (str(characteristics_name[0]), characteristics_mea_val[0]))
        cursor.execute("INSERT INTO Measuringvalues (Characteristic, `value`) VALUES (?, ?)", (str(characteristics_name[1]), characteristics_mea_val[1]))
        conn.commit()
        
        result[0] = 0 # Set result register to 0 -> No error
    except:
        # Error
        result[0] = 1 # Set result register to 1 -> Error
    finally:
        # Verbindung schließen
        cursor.close()
        conn.close()
    
    # For Debugging of python and to see the prints, uncomment the line "time.sleep(10)" and activate Debug-mode in SFct047. 
    # This forces the terminal to show and to wait for 10 seconds before exit.
    #time.sleep(10)
    
    return 0